"""Configuracion del servidor central ICEBERG POS."""
import os
import json

BASE_DIR = os.path.dirname(os.path.abspath(__file__))

# --- Cargar config_venue.json si existe (generado por Operator) ---
_venue_cfg = {}
_venue_json_path = os.path.join(BASE_DIR, "config_venue.json")
if os.path.exists(_venue_json_path):
    with open(_venue_json_path, "r", encoding="utf-8") as f:
        _venue_cfg = json.load(f)
    print(f"[Config] Cargado config_venue.json: {_venue_cfg.get('venue_name', '?')}")
else:
    print("[Config] Sin config_venue.json — usando defaults de desarrollo")

# Version (debe coincidir con app/config.py APP_VERSION)
APP_VERSION = _venue_cfg.get("app_version", "2.0.1")

# Red
SERVER_HOST = _venue_cfg.get("server_host", "0.0.0.0")
SERVER_PORT = _venue_cfg.get("server_port", 8000)
SUBNET = _venue_cfg.get("subnet", "10.0.15")

# Agents registrados (se llena dinamicamente al registrarse cada agent)
# Formato: {"agent_id": {"host": "10.0.15.10", "port": 5555}}
REGISTERED_AGENTS = {}

# Database
DATABASE_PATH = os.path.join(BASE_DIR, "iceberg.db")
DATABASE_URL = f"sqlite:///{DATABASE_PATH}"

# Venue
VENUE_ID = _venue_cfg.get("venue_id", "dev-local").lower()
VENUE_NAME = _venue_cfg.get("venue_name", "ICEBERG Dev")
VENUE_PREFIX = _venue_cfg.get("terminal_prefix", "DEV")

# Cloud Sync
CLOUD_SYNC_URL = _venue_cfg.get("cloud_sync_url", "https://icebergecuador.com/Cuenca/Plan/api/sync.php")
CLOUD_SYNC_KEY = "iceberg-sync-2026"
CLOUD_SYNC_INTERVAL = 15              # segundos entre cada intento de sync
CLOUD_SYNC_BATCH_SIZE = 50            # registros por lote

# Cloud Poller (Operator → Local)
OPERATOR_API_URL = _venue_cfg.get("operator_api_url", "https://icebergecuador.com/Cuenca/Operator/api.php")
CLOUD_POLL_INTERVAL = 15              # segundos entre cada poll de pending_changes

# Paquetes default (se crean al iniciar si no existen)
DEFAULT_PACKAGES = [
    {"id": "30min",  "name": "Paquete 30 Min",  "minutes": 30,  "price": 3.50, "color": "blue"},
    {"id": "60min",  "name": "Paquete 60 Min",  "minutes": 60,  "price": 5.00, "color": "green"},
    {"id": "120min", "name": "Paquete 120 Min", "minutes": 120, "price": 8.00, "color": "red"},
    {"id": "cumple", "name": "Cumpleanos",       "minutes": 180, "price": 25.00, "color": "all"},
]
