"""ICEBERG Server - Entry point para PyInstaller.

Arranca uvicorn programáticamente para que PyInstaller
pueda empaquetar todo en un solo ejecutable.
"""
import uvicorn
import sys
import os

# Asegurar que el directorio del exe sea el CWD
if getattr(sys, 'frozen', False):
    os.chdir(os.path.dirname(sys.executable))
else:
    os.chdir(os.path.dirname(os.path.abspath(__file__)))

# Agregar el directorio actual al path
sys.path.insert(0, os.getcwd())

if __name__ == "__main__":
    uvicorn.run("main:app", host="0.0.0.0", port=8000)
