"""Validacion de PIN de supervisor contra el cloud (Operator API)."""
import httpx
from config import CLOUD_SYNC_KEY, VENUE_ID

OPERATOR_URL = "https://icebergecuador.com/Cuenca/Operator/api.php"
CLOUD_TIMEOUT = 8  # segundos


async def validar_pin_supervisor(pin: str, accion: str, solicitante: str, motivo: str = "") -> dict:
    """
    Valida un PIN de supervisor contra el cloud.
    Retorna {'status':'ok', 'supervisor':..., 'supervisor_id':...} si valido.
    Lanza Exception si el cloud no responde.
    """
    async with httpx.AsyncClient(timeout=CLOUD_TIMEOUT) as client:
        resp = await client.post(
            f"{OPERATOR_URL}?action=supervisor_pin_validate",
            json={
                "pin": pin,
                "accion": accion,
                "solicitante": solicitante,
                "motivo": motivo,
                "venue_id": VENUE_ID,
                "app_key": CLOUD_SYNC_KEY,
            },
        )

    data = resp.json()
    return data
