"""Configuracion del Hardware Agent."""
import os
import json
from urllib.parse import urlparse

_BASE_DIR = os.path.dirname(os.path.abspath(__file__))

# --- Cargar config_venue.json si existe (generado por Operator) ---
_venue_cfg = {}
_venue_json_path = os.path.join(_BASE_DIR, "config_venue.json")
if os.path.exists(_venue_json_path):
    with open(_venue_json_path, "r", encoding="utf-8") as f:
        _venue_cfg = json.load(f)
    print(f"[Agent Config] Cargado config_venue.json")
else:
    print("[Agent Config] Sin config_venue.json — usando defaults de desarrollo")

PORT = _venue_cfg.get("agent_port", 5555)
HOST = '0.0.0.0'

# Parsear server_url si existe
_server_url = _venue_cfg.get("server_url", "")
if _server_url:
    _parsed = urlparse(_server_url)
    SERVER_HOST = _parsed.hostname or "127.0.0.1"
    SERVER_PORT = _parsed.port or 8000
else:
    SERVER_HOST = "127.0.0.1"
    SERVER_PORT = 8000

# Agent identity
_prefix = _venue_cfg.get("terminal_prefix", "DEV")
AGENT_ID = _venue_cfg.get("agent_id", f"{_prefix}001")
AGENT_NAME = _venue_cfg.get("agent_name", "Caja 1")

HEARTBEAT_INTERVAL = 30                # segundos entre heartbeats

# Token de autenticacion — se genera/carga al arranque (ver agent.py)
# No modificar aqui; el token real se almacena en agent_token.txt
AGENT_TOKEN = ''
