"""
Estado global de la sesion activa (usuario autenticado).
Se establece en app/main.py tras el login exitoso y se limpia al cerrar sesion.

Uso:
    import session
    session.tiene_permiso("lb_vender")  -> bool
    session.get_user()                  -> dict
    session.get_venue_id()              -> str
"""

_s: dict = {}


def set_session(
    user: dict,
    permissions: list,
    venues: list,
    venue_id: str,
    offline: bool = False,
):
    _s.clear()
    _s.update({
        "user":        user,
        "permissions": permissions,
        "venues":      venues,
        "venue_id":    venue_id,
        "offline":     offline,
    })


def clear():
    _s.clear()


def get_user() -> dict:
    return _s.get("user", {})


def get_permissions() -> list:
    return _s.get("permissions", [])


def tiene_permiso(permiso: str) -> bool:
    """Retorna True si el usuario tiene el permiso dado (o tiene 'all')."""
    perms = _s.get("permissions", [])
    return "all" in perms or permiso in perms


def get_venue_id() -> str:
    return _s.get("venue_id", "")


def is_offline() -> bool:
    return _s.get("offline", False)
